package com.biz.crm.dms.business.stock.customer.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatisticsDetail;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDetailDto;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;

/**
 * 库存提报明细子表(StockStatisticsDetail)表服务接口
 *
 * @author HanJiaJun
 * @since 2022-07-26 15:16:37
 */
public interface StockStatisticsDetailService{

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param stockStatisticsDetail 实体对象
   * @return
   */
  Page<StockStatisticsDetail> findByConditions(Pageable pageable, StockStatisticsDetailDto stockStatisticsDetail);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  StockStatisticsDetail findById(String id);
  
   /**
   * 新增数据
   * @param stockStatisticsDetail 实体对象
   * @return 新增结果
   */
  StockStatisticsDetail create(StockStatisticsDetail stockStatisticsDetail);

  /**
   * 批量新增数据
   * @param stockStatisticsDetails
   * @return
   */
  List<StockStatisticsDetail> createBatch(List<StockStatisticsDetail> stockStatisticsDetails);
   /**
   * 修改新据
   * @param stockStatisticsDetail 实体对象
   * @return 修改结果
   */
  StockStatisticsDetail update(StockStatisticsDetail stockStatisticsDetail);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 通过客户编码、产品编码、库存时间
   * @param cusCode
   * @param productCode
   * @param time
   */
  List<StockStatisticsDetail> findByCusCodeAndProductCodeAndTime(String cusCode, String productCode, Date time);
}

