package com.biz.crm.dms.business.stock.customer.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatisticsDetail;
import com.biz.crm.dms.business.stock.customer.local.repository.StockStatisticsDetailRepository;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsDetailService;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDetailDto;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 库存提报明细子表(StockStatisticsDetail)表服务实现类
 *
 * @author HanJiaJun
 * @since 2022-07-26 15:16:37
 */
@Service("stockStatisticsDetailService")
public class StockStatisticsDetailServiceImpl implements StockStatisticsDetailService {

  @Autowired
  private StockStatisticsDetailRepository stockStatisticsDetailRepository;

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param stockStatisticsDetail 实体对象
   * @return
   */
  @Override
  public Page<StockStatisticsDetail> findByConditions(Pageable pageable, StockStatisticsDetailDto stockStatisticsDetail) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(stockStatisticsDetail)) {
      stockStatisticsDetail = new StockStatisticsDetailDto();
    }
    if (ObjectUtils.isNotEmpty( stockStatisticsDetail.getBeginTime())){
      Date beginTime = stockStatisticsDetail.getBeginTime();
      Calendar calendar=Calendar.getInstance();
      calendar.setTime(beginTime);
      calendar.set(Calendar.HOUR_OF_DAY, 00);
      calendar.set(Calendar.MINUTE, 00);
      calendar.set(Calendar.SECOND, 00);
      stockStatisticsDetail.setBeginTime(calendar.getTime());
    }
    if (ObjectUtils.isNotEmpty( stockStatisticsDetail.getEndTime())){
      Date endTime = stockStatisticsDetail.getEndTime();
      Calendar calendar=Calendar.getInstance();
      calendar.setTime(endTime);
      calendar.set(Calendar.HOUR_OF_DAY, 23);
      calendar.set(Calendar.MINUTE, 59);
      calendar.set(Calendar.SECOND, 59);
      stockStatisticsDetail.setEndTime(calendar.getTime());
    }
    return this.stockStatisticsDetailRepository.findByConditions(pageable, stockStatisticsDetail);
  }
  
  /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public StockStatisticsDetail findById(String id) {
    if (StringUtils.isBlank(id)) {
	  return null;
	}
    return this.stockStatisticsDetailRepository.getById(id);
  }
  
  /**
   * 新增数据
   * @param stockStatisticsDetail 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public StockStatisticsDetail create(StockStatisticsDetail stockStatisticsDetail) {
    this.createValidate(stockStatisticsDetail);
    this.stockStatisticsDetailRepository.saveOrUpdate(stockStatisticsDetail);
    return stockStatisticsDetail;
  }

  /**
   * 批量新增
   * @param stockStatisticsDetails
   * @return
   */
  @Override
  public List<StockStatisticsDetail> createBatch(List<StockStatisticsDetail> stockStatisticsDetails) {
    Validate.notEmpty(stockStatisticsDetails,"新增数据时，列表不能为空");
    for (StockStatisticsDetail stockStatisticsDetail : stockStatisticsDetails) {
      this.createValidate(stockStatisticsDetail);
    }
    this.stockStatisticsDetailRepository.saveBatch(stockStatisticsDetails);
    return stockStatisticsDetails;
  }

  /**
   * 修改新据
   * @param stockStatisticsDetail 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public StockStatisticsDetail update(StockStatisticsDetail stockStatisticsDetail) {
    this.updateValidate(stockStatisticsDetail);
    this.stockStatisticsDetailRepository.saveOrUpdate(stockStatisticsDetail);
    return stockStatisticsDetail;
  }
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.stockStatisticsDetailRepository.removeByIds(idList);
  }

  @Override
  public List<StockStatisticsDetail> findByCusCodeAndProductCodeAndTime(String cusCode, String productCode, Date time) {
    if (StringUtils.isNoneBlank(cusCode,productCode) && Objects.nonNull(time)){
      return this.stockStatisticsDetailRepository.findByCusCodeAndProductCodeAndTime(cusCode,productCode,time);
    }
    return new ArrayList<>(0);
  }

  /**
   * 创建验证
   * @param stockStatisticsDetail
   */
  private void createValidate(StockStatisticsDetail stockStatisticsDetail) {
    Validate.notNull(stockStatisticsDetail, "新增时，对象信息不能为空！");
	  stockStatisticsDetail.setId(null);
     
  }
  
   /**
   * 修改验证
   * @param stockStatisticsDetail
   */
  private void updateValidate(StockStatisticsDetail stockStatisticsDetail) {
    Validate.notNull(stockStatisticsDetail, "修改时，对象信息不能为空！");
    Validate.notBlank(stockStatisticsDetail.getId(), "修改数据时，ID不能为空！");
      
  }
}

