package com.biz.crm.dms.business.stock.customer.local.service.internal;

import com.biz.crm.dms.business.stock.customer.local.entity.StockStatisticsDetail;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsDetailService;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDetailDto;
import com.biz.crm.dms.business.stock.customer.sdk.service.StockStatisticsDetailVoService;
import com.biz.crm.dms.business.stock.customer.sdk.vo.StockStatisticsDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年07月28日 15:27:00
 */
@Service
public class StockStatisticsDetailVoServiceImpl implements StockStatisticsDetailVoService {

  @Autowired
  private StockStatisticsDetailService stockStatisticsDetailService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<StockStatisticsDetailVo> findDetailByConditions(StockStatisticsDetailDto detailDto) {
    if (ObjectUtils.isEmpty(detailDto)) {
      return null;
    }
    Date operationTime = detailDto.getOperationTime();
    if (Objects.isNull(operationTime)) {
      operationTime = new Date();
    }
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(operationTime);
    calendar.set(Calendar.HOUR_OF_DAY, 23);
    calendar.set(Calendar.MINUTE, 59);
    calendar.set(Calendar.SECOND,59);
    Date time = calendar.getTime();
    List<StockStatisticsDetail> byCusCodeAndProductCodeAndTime = stockStatisticsDetailService.findByCusCodeAndProductCodeAndTime(detailDto.getCusCode(), detailDto.getProductCode(), time);
    if (CollectionUtils.isEmpty(byCusCodeAndProductCodeAndTime)) {
      return null;
    }
    return (List<StockStatisticsDetailVo>) this.nebulaToolkitService.copyCollectionByWhiteList(byCusCodeAndProductCodeAndTime, StockStatisticsDetail.class, StockStatisticsDetailVo.class, HashSet.class, ArrayList.class);
  }
}
