/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.stock.customer.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDto;
import com.biz.crm.dms.business.stock.customer.sdk.service.StockStatisticsVoService;
import com.biz.crm.dms.business.stock.customer.sdk.vo.StockStatisticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/stockStatistics/stockStatistics"})
@Api(tags={"\u5e93\u5b58\u63d0\u62a5Dto:StockStatisticsVo:\u5e93\u5b58\u63d0\u62a5Dto"})
public class StockStatisticsVoController {
    private static final Logger log = LoggerFactory.getLogger(StockStatisticsVoController.class);
    @Autowired
    private StockStatisticsVoService stockStatisticsVoService;

    @ApiOperation(value="\u5e93\u5b58\u63d0\u62a5")
    @PostMapping
    public Result<?> create(@ApiParam(name="StockStatisticsVo", value="\u5e93\u5b58\u63d0\u62a5\u660e\u7ec6\u5b50\u8868") @RequestBody List<StockStatisticsDto> stockStatisticsVos) {
        try {
            this.stockStatisticsVoService.create(stockStatisticsVos);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5e93\u5b58\u63d0\u62a5\u754c\u9762\u67e5\u8be2")
    @GetMapping(value={"/findDetailByCusCode"})
    public Result<List<StockStatisticsVo>> findDetailByCusCode(@ApiParam(name="stockStatistics", value="\u5e93\u5b58\u63d0\u62a5\u4e3b\u8868") StockStatisticsDto dto) {
        try {
            List res = this.stockStatisticsVoService.findDetailByCusCode(dto);
            return Result.ok((Object)res);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5e93\u5b58\u63d0\u62a5\u754c\u9762\u67e5\u8be2\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByStockStatisticsDto"})
    public Result<Page<StockStatisticsVo>> findByStockStatisticsDto(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="stockStatistics", value="\u5e93\u5b58\u63d0\u62a5\u4e3b\u8868") StockStatisticsDto dto) {
        try {
            return Result.ok((Object)this.stockStatisticsVoService.findByStockStatisticsDto(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

