/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.stock.customer.local.service.internal;

import com.biz.crm.dms.business.stock.customer.local.entity.StockStatisticsDetail;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsDetailService;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDetailDto;
import com.biz.crm.dms.business.stock.customer.sdk.service.StockStatisticsDetailVoService;
import com.biz.crm.dms.business.stock.customer.sdk.vo.StockStatisticsDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class StockStatisticsDetailVoServiceImpl
implements StockStatisticsDetailVoService {
    @Autowired
    private StockStatisticsDetailService stockStatisticsDetailService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public List<StockStatisticsDetailVo> findDetailByConditions(StockStatisticsDetailDto detailDto) {
        if (ObjectUtils.isEmpty((Object)detailDto)) {
            return null;
        }
        Date operationTime = detailDto.getOperationTime();
        if (Objects.isNull(operationTime)) {
            operationTime = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(operationTime);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date time = calendar.getTime();
        List<StockStatisticsDetail> byCusCodeAndProductCodeAndTime = this.stockStatisticsDetailService.findByCusCodeAndProductCodeAndTime(detailDto.getCusCode(), detailDto.getProductCode(), time);
        if (CollectionUtils.isEmpty(byCusCodeAndProductCodeAndTime)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(byCusCodeAndProductCodeAndTime, StockStatisticsDetail.class, StockStatisticsDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

