/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.stock.customer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListVoService;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatistics;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatisticsDetail;
import com.biz.crm.dms.business.stock.customer.local.repository.StockStatisticsRepository;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsDetailService;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsService;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsPageDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="stockStatisticsService")
public class StockStatisticsServiceImpl
implements StockStatisticsService {
    @Autowired
    private AllowSaleListVoService allowSaleListVoService;
    @Autowired
    private ProductVoService productVoService;
    @Autowired
    private StockStatisticsRepository stockStatisticsRepository;
    @Autowired
    private CustomerVoService customerVoService;
    @Autowired
    private StockStatisticsDetailService stockStatisticsDetailService;

    @Override
    public Page<StockStatistics> findByConditions(Pageable pageable, StockStatisticsPageDto stockStatistics) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(stockStatistics)) {
            stockStatistics = new StockStatisticsPageDto();
        }
        Date time = null;
        if (!Objects.isNull(stockStatistics.getStockTime())) {
            Date stockTime = stockStatistics.getStockTime();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(stockTime);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            time = calendar.getTime();
            stockStatistics.setStockTime(time);
        }
        stockStatistics.setTenantCode(TenantUtils.getTenantCode());
        Page<StockStatistics> byConditions = this.stockStatisticsRepository.findByConditions(pageable, stockStatistics);
        if (Objects.isNull(stockStatistics.getStockTime())) {
            return byConditions;
        }
        List records = byConditions.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return byConditions;
        }
        for (StockStatistics record : records) {
            String productCode;
            String cusCode = record.getCusCode();
            List<StockStatisticsDetail> byCusCodeAndProductCodeAndTime = this.stockStatisticsDetailService.findByCusCodeAndProductCodeAndTime(cusCode, productCode = record.getProductCode(), time);
            if (!CollectionUtils.isEmpty(byCusCodeAndProductCodeAndTime)) {
                StockStatisticsDetail stockStatisticsDetail = byCusCodeAndProductCodeAndTime.get(0);
                record.setStockQuantity(stockStatisticsDetail.getQuantity());
                record.setStockTime(stockStatisticsDetail.getOperationTime());
                continue;
            }
            record.setStockTime(null);
            record.setStockQuantity(null);
        }
        return byConditions;
    }

    @Override
    public StockStatistics findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (StockStatistics)((Object)this.stockStatisticsRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public StockStatistics create(StockStatistics stockStatistics) {
        this.createValidate(stockStatistics);
        this.stockStatisticsRepository.saveOrUpdate((Object)stockStatistics);
        return stockStatistics;
    }

    @Override
    @Transactional
    public StockStatistics update(StockStatistics stockStatistics) {
        this.updateValidate(stockStatistics);
        this.stockStatisticsRepository.saveOrUpdate((Object)stockStatistics);
        return stockStatistics;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.stockStatisticsRepository.removeByIds(idList);
    }

    @Override
    public StockStatistics findByCusCodeAndProductCode(String cusCode, String productCode) {
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cusCode, productCode})) {
            return null;
        }
        return this.stockStatisticsRepository.findByCusCodeAndProductCode(cusCode, productCode);
    }

    @Override
    public List<StockStatistics> findByCusCode(String cusCode) {
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cusCode})) {
            return null;
        }
        return this.stockStatisticsRepository.findByCusCode(cusCode);
    }

    private void createValidate(StockStatistics stockStatistics) {
        Validate.notNull((Object)((Object)stockStatistics), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        stockStatistics.setId(null);
        stockStatistics.setTenantCode(TenantUtils.getTenantCode());
        stockStatistics.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        stockStatistics.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Validate.notNull((Object)stockStatistics.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(StockStatistics stockStatistics) {
        Validate.notNull((Object)((Object)stockStatistics), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stockStatistics.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stockStatistics.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

