/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.stock.customer.local.service.strategy.adjust;

import com.biz.crm.dms.business.stock.customer.local.entity.StockStatistics;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatisticsDetail;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsDetailService;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsService;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDto;
import com.biz.crm.dms.business.stock.customer.sdk.strategy.StockStatisticsAdjustTypeStrategy;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StockStatisticsAdjustTypeStrategyImpl
implements StockStatisticsAdjustTypeStrategy {
    @Autowired
    private StockStatisticsService stockStatisticsService;
    @Autowired
    private StockStatisticsDetailService stockStatisticsDetailService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CustomerVoService customerVoService;

    public String getAdjustTypeCode() {
        return "stock_update";
    }

    public String getAdjustTypeName() {
        return "\u5e93\u5b58\u66f4\u65b0";
    }

    public void adjustHandle(List<StockStatisticsDto> statisticsDtoList) {
        List cusCodes = statisticsDtoList.stream().map(StockStatisticsDto::getCusCode).collect(Collectors.toList());
        List byCustomerCodes = this.customerVoService.findByCustomerCodes(cusCodes);
        Validate.notEmpty((Collection)byCustomerCodes, (String)"\u5e93\u5b58\u63d0\u62a5\uff0c\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5ba2\u6237\u4fe1\u606f", (Object[])new Object[0]);
        Map<String, CustomerVo> customerVoMap = byCustomerCodes.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, e -> e));
        Date date = new Date();
        for (StockStatisticsDto dto : statisticsDtoList) {
            List orgList;
            String productCode;
            String cusCode = dto.getCusCode();
            StockStatistics stockStatistics = this.stockStatisticsService.findByCusCodeAndProductCode(cusCode, productCode = dto.getProductCode());
            if (Objects.nonNull((Object)stockStatistics)) {
                List orgList2;
                stockStatistics.setStockTime(date);
                stockStatistics.setStockQuantity(dto.getOperationQuantity());
                CustomerVo customerVo = customerVoMap.get(cusCode);
                if (Objects.nonNull(customerVo) && CollectionUtils.isNotEmpty((Collection)(orgList2 = customerVo.getOrgList()))) {
                    CustomerRelateOrgVo customerRelateOrgVo = (CustomerRelateOrgVo)orgList2.get(0);
                    stockStatistics.setCusOrgCode(customerRelateOrgVo.getOrgCode());
                    stockStatistics.setCusOrgName(customerRelateOrgVo.getOrgName());
                }
                this.stockStatisticsService.update(stockStatistics);
                continue;
            }
            StockStatistics entity = (StockStatistics)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, StockStatistics.class, HashSet.class, ArrayList.class, new String[0]));
            entity.setStockTime(date);
            entity.setStockQuantity(dto.getOperationQuantity());
            CustomerVo customerVo = customerVoMap.get(cusCode);
            if (Objects.nonNull(customerVo) && CollectionUtils.isNotEmpty((Collection)(orgList = customerVo.getOrgList()))) {
                CustomerRelateOrgVo customerRelateOrgVo = (CustomerRelateOrgVo)orgList.get(0);
                entity.setCusOrgCode(customerRelateOrgVo.getOrgCode());
                entity.setCusOrgName(customerRelateOrgVo.getOrgName());
            }
            this.stockStatisticsService.create(entity);
        }
        Collection stockStatisticsDetails = this.nebulaToolkitService.copyCollectionByWhiteList(statisticsDtoList, StockStatisticsDto.class, StockStatisticsDetail.class, HashSet.class, ArrayList.class, new String[0]);
        for (StockStatisticsDetail stockStatisticsDetail : stockStatisticsDetails) {
            String cusCode;
            CustomerVo customerVo;
            if (!StringUtils.isBlank((CharSequence)stockStatisticsDetail.getOperationOrgCode()) || !Objects.nonNull(customerVo = customerVoMap.get(cusCode = stockStatisticsDetail.getCusCode()))) continue;
            List orgList = customerVo.getOrgList();
            if (CollectionUtils.isNotEmpty((Collection)orgList)) {
                CustomerRelateOrgVo customerRelateOrgVo = (CustomerRelateOrgVo)orgList.get(0);
                stockStatisticsDetail.setOperationOrgCode(customerRelateOrgVo.getOrgCode());
                stockStatisticsDetail.setOperationOrgName(customerRelateOrgVo.getOrgName());
            }
            stockStatisticsDetail.setOperationTime(date);
            stockStatisticsDetail.setQuantity(stockStatisticsDetail.getOperationQuantity());
        }
        this.stockStatisticsDetailService.createBatch((List)stockStatisticsDetails);
    }
}

