package com.biz.crm.dms.business.stock.customer.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatisticsDetail;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsDetailService;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDetailDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 库存提报明细子表(StockStatisticsDetail)表相关的http接口
 *
 * @author HanJiaJun
 * @since 2022-07-26 15:16:37
 */
@RestController
@RequestMapping("/v1/stockStatisticsDetail/stockStatisticsDetail")
@Slf4j
@Api(tags = "库存提报明细子表:StockStatisticsDetail:库存提报明细子表")
public class StockStatisticsDetailController {
  /**
  * 服务对象
  */
  @Autowired
  private StockStatisticsDetailService stockStatisticsDetailService;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param stockStatisticsDetail 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<StockStatisticsDetail>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
												   @ApiParam(name = "stockStatisticsDetail", value = "库存提报明细子表") StockStatisticsDetailDto stockStatisticsDetail) {
    try {
      Page<StockStatisticsDetail> page =  this.stockStatisticsDetailService.findByConditions(pageable,stockStatisticsDetail);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<StockStatisticsDetail> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      StockStatisticsDetail stockStatisticsDetail = this.stockStatisticsDetailService.findById(id);
      return Result.ok(stockStatisticsDetail);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
