package com.biz.crm.dms.business.stock.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author HanJiaJun
 * @describe: 库存提报主表
 * @createTime 2022年07月25日 16:29:00
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StockStatistics", description = "库存提报主表实体")
@Entity
@TableName("dms_stock_statistics")
@Table(name = "dms_stock_statistics",
    indexes = {@Index(columnList = "tenant_code,cus_code,product_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_stock_statistics", comment = "库存提报主表")
public class StockStatistics extends TenantFlagOpEntity {

  private static final long serialVersionUID = 265214412457786598L;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "cusCode", value = "客户编码", required = true)
  @Column(name = "cus_code", length = 64, columnDefinition = "VARCHAR(128)  COMMENT '客户编码'")
  private String cusCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(name = "cusName", value = "客户名称", required = true)
  @Column(name = "cus_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '客户名称'")
  private String cusName;

  /**
   * 客户所属企业组织编码
   */
  @ApiModelProperty(name = "cusOrgCode", value = "客户所属企业组织编码", required = true)
  @Column(name = "cus_org_code", length = 64, columnDefinition = "VARCHAR(128)  COMMENT '客户所属组织编码'")
  private String cusOrgCode;

  /**
   * 客户所属企业组织编码
   */
  @ApiModelProperty(name = "cusOrgName", value = "客户所属企业组织编码", required = true)
  @Column(name = "cus_org_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '客户所属组织名称'")
  private String cusOrgName;
  /**
   * 商品编码
   */
  @ApiModelProperty(name = "productCode", value = "商品编码", required = true)
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(128)  COMMENT '商品编码'")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty(name = "productName", value = "商品名称", required = true)
  @Column(name = "product_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '商品名称'")
  private String productName;

  /**
   * 商品单位
   */
  @ApiModelProperty(name = "productUnit", value = "商品单位", required = true)
  @Column(name = "product_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品单位 '")
  private String productUnit;

  /**
   * 库存量
   */
  @ApiModelProperty(name = "stockQuantity", value = "库存量", required = true)
  @Column(name = "stock_quantity", length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 库存量 '")
  private BigDecimal stockQuantity;


  /**
   * 库存时间
   */
  @ApiModelProperty(name = "stockTime", value = "库存时间", required = true)
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "stock_time", length = 20, columnDefinition = "datetime COMMENT '库存时间'")
  private Date stockTime;
}
