package com.biz.crm.dms.business.stock.customer.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatisticsDetail;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDetailDto;
import org.apache.ibatis.annotations.Param;

/**
 * 库存提报明细子表(StockStatisticsDetail)表mybatis访问层
 *
 * @author HanJiaJun
 * @since 2022-07-26 15:16:37
 */
public interface StockStatisticsDetailMapper extends BaseMapper<StockStatisticsDetail> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param stockStatisticsDetail 查询实体
   * @return 所有数据
  */
  public Page<StockStatisticsDetail> findByConditions(@Param("page") Page<StockStatisticsDetail> page, @Param("dto") StockStatisticsDetailDto stockStatisticsDetail);
}

