package com.biz.crm.dms.business.stock.customer.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatistics;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsPageDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;

/**
 * 库存提报主表(StockStatistics)表mybatis访问层
 *
 * @author HanJiaJun
 * @since 2022-07-26 15:15:59
 */
public interface StockStatisticsMapper extends BaseMapper<StockStatistics> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param stockStatistics 查询实体
   * @return 所有数据
  */
  public Page<StockStatistics> findByConditions(@Param("page") Page<StockStatistics> page, @Param("dto") StockStatisticsPageDto stockStatistics);

  /**
   * 通过编码分页查询
   * @param pageable
   * @param cusCode
   * @return
   */
  Page<StockStatistics> findPageByCusCode(@Param("page")Pageable pageable,  @Param("cusCode") String cusCode);
}

