package com.biz.crm.dms.business.stock.customer.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatisticsDetail;
import com.biz.crm.dms.business.stock.customer.local.mapper.StockStatisticsDetailMapper;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDetailDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;


/**
 * 库存提报明细子表(StockStatisticsDetail)表数据库访问层
 *
 * @author HanJiaJun
 * @since 2022-07-26 15:16:37
 */
@Component
public class StockStatisticsDetailRepository extends ServiceImpl<StockStatisticsDetailMapper, StockStatisticsDetail> {

  @Autowired
  private StockStatisticsDetailMapper stockStatisticsDetailMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param stockStatisticsDetail 实体对象
   * @return
   */
  public Page<StockStatisticsDetail> findByConditions(Pageable pageable, StockStatisticsDetailDto stockStatisticsDetail) {
    Page<StockStatisticsDetail> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<StockStatisticsDetail> pageList = stockStatisticsDetailMapper.findByConditions(page, stockStatisticsDetail);
    return pageList;
  }

  /**
   * 通过客户编码，产品编码查询当前时间之前的
   * @param cusCode
   * @param productCode
   * @param time
   */
  public List<StockStatisticsDetail> findByCusCodeAndProductCodeAndTime(String cusCode, String productCode, Date time) {
    return this
        .lambdaQuery()
        .eq(StockStatisticsDetail::getCusCode,cusCode)
        .eq(StockStatisticsDetail::getProductCode,productCode)
        .le(StockStatisticsDetail::getOperationTime,time)
        .orderByDesc(StockStatisticsDetail::getOperationTime)
        .list();
  }
}

