package com.biz.crm.dms.business.stock.customer.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatistics;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsPageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 库存提报主表(StockStatistics)表服务接口
 *
 * @author HanJiaJun
 * @since 2022-07-26 15:15:59
 */
public interface StockStatisticsService{

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param stockStatistics 实体对象
   * @return
   */
  Page<StockStatistics> findByConditions(Pageable pageable, StockStatisticsPageDto stockStatistics);

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param cusCode 实体对象
   * @return
   */
  Page<StockStatistics> findPageByCusCode(Pageable pageable, String cusCode);

   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  StockStatistics findById(String id);
  
   /**
   * 新增数据
   * @param stockStatistics 实体对象
   * @return 新增结果
   */
  StockStatistics create(StockStatistics stockStatistics);
  
   /**
   * 修改新据
   * @param stockStatistics 实体对象
   * @return 修改结果
   */
  StockStatistics update(StockStatistics stockStatistics);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 通过客户编码和产品编码查询
   * @param cusCode
   * @param productCode
   */
  StockStatistics findByCusCodeAndProductCode(String cusCode, String productCode);

  /**
   *  通过客户编码查询
   * @param cusCode
   */
  List<StockStatistics> findByCusCode(String cusCode);

}

