package com.biz.crm.dms.business.stock.customer.local.service.strategy.operation;

import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDto;
import com.biz.crm.dms.business.stock.customer.sdk.strategy.StockStatisticsAdjustTypeStrategy;
import com.biz.crm.dms.business.stock.customer.sdk.strategy.StockStatisticsOperationTypeStrategy;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author HanJiaJun
 * @describe: 库存提报(stock_statistics)操作类型策略器实现
 * @createTime 2022年07月27日 12:04:00
 */
@Component
public class StockStatisticsOperationTypeStrategyImpl implements StockStatisticsOperationTypeStrategy {

  @Autowired
  private List<StockStatisticsAdjustTypeStrategy> stockStatisticsAdjustTypeStrategies;

  @Override
  public String getOperationTypeCode() {
    return "stock_statistics";
  }

  @Override
  public String getOperationTypeName() {
    return "库存提报";
  }

  /**
   * 执行
   * @param stockStatisticsDto
   */
  @Override
  public void operationHandle(List<StockStatisticsDto> stockStatisticsDto) {
    /**
     * 1. 校验
     * 2. 查找调整类型策略器
     */
    Validate.notNull(stockStatisticsDto,"库存提报，数据对象不能为空");
    Validate.notEmpty(stockStatisticsAdjustTypeStrategies," 库存提报，未查询到调整类型策略器");
    Map<String, List<StockStatisticsDto>> collect = stockStatisticsDto.stream().collect(Collectors.groupingBy(StockStatisticsDto::getAdjustType));
   collect.forEach((k,v)->{
     for (StockStatisticsAdjustTypeStrategy stockStatisticsAdjustTypeStrategy : stockStatisticsAdjustTypeStrategies) {
       if (stockStatisticsAdjustTypeStrategy.getAdjustTypeCode().equals(k)){
         stockStatisticsAdjustTypeStrategy.adjustHandle(v);
       }
     }
   });
  }
}
