/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.stock.customer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatisticsDetail;
import com.biz.crm.dms.business.stock.customer.local.repository.StockStatisticsDetailRepository;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsDetailService;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDetailDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="stockStatisticsDetailService")
public class StockStatisticsDetailServiceImpl
implements StockStatisticsDetailService {
    @Autowired
    private StockStatisticsDetailRepository stockStatisticsDetailRepository;

    @Override
    public Page<StockStatisticsDetail> findByConditions(Pageable pageable, StockStatisticsDetailDto stockStatisticsDetail) {
        Calendar calendar;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(stockStatisticsDetail)) {
            stockStatisticsDetail = new StockStatisticsDetailDto();
        }
        if (ObjectUtils.isNotEmpty((Object)stockStatisticsDetail.getBeginTime())) {
            Date beginTime = stockStatisticsDetail.getBeginTime();
            calendar = Calendar.getInstance();
            calendar.setTime(beginTime);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            stockStatisticsDetail.setBeginTime(calendar.getTime());
        }
        if (ObjectUtils.isNotEmpty((Object)stockStatisticsDetail.getEndTime())) {
            Date endTime = stockStatisticsDetail.getEndTime();
            calendar = Calendar.getInstance();
            calendar.setTime(endTime);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            stockStatisticsDetail.setEndTime(calendar.getTime());
        }
        return this.stockStatisticsDetailRepository.findByConditions(pageable, stockStatisticsDetail);
    }

    @Override
    public StockStatisticsDetail findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (StockStatisticsDetail)((Object)this.stockStatisticsDetailRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public StockStatisticsDetail create(StockStatisticsDetail stockStatisticsDetail) {
        this.createValidate(stockStatisticsDetail);
        this.stockStatisticsDetailRepository.saveOrUpdate((Object)stockStatisticsDetail);
        return stockStatisticsDetail;
    }

    @Override
    public List<StockStatisticsDetail> createBatch(List<StockStatisticsDetail> stockStatisticsDetails) {
        Validate.notEmpty(stockStatisticsDetails, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (StockStatisticsDetail stockStatisticsDetail : stockStatisticsDetails) {
            this.createValidate(stockStatisticsDetail);
        }
        this.stockStatisticsDetailRepository.saveBatch(stockStatisticsDetails);
        return stockStatisticsDetails;
    }

    @Override
    @Transactional
    public StockStatisticsDetail update(StockStatisticsDetail stockStatisticsDetail) {
        this.updateValidate(stockStatisticsDetail);
        this.stockStatisticsDetailRepository.saveOrUpdate((Object)stockStatisticsDetail);
        return stockStatisticsDetail;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.stockStatisticsDetailRepository.removeByIds(idList);
    }

    @Override
    public List<StockStatisticsDetail> findByCusCodeAndProductCodeAndTime(String cusCode, String productCode, Date time) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cusCode, productCode}) && Objects.nonNull(time)) {
            return this.stockStatisticsDetailRepository.findByCusCodeAndProductCodeAndTime(cusCode, productCode, time);
        }
        return new ArrayList<StockStatisticsDetail>(0);
    }

    private void createValidate(StockStatisticsDetail stockStatisticsDetail) {
        Validate.notNull((Object)((Object)stockStatisticsDetail), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        stockStatisticsDetail.setId(null);
    }

    private void updateValidate(StockStatisticsDetail stockStatisticsDetail) {
        Validate.notNull((Object)((Object)stockStatisticsDetail), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)stockStatisticsDetail.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

