/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.stock.customer.local.service.internal;

import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListVoService;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatistics;
import com.biz.crm.dms.business.stock.customer.local.repository.StockStatisticsRepository;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsDetailService;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsService;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDto;
import com.biz.crm.dms.business.stock.customer.sdk.service.StockStatisticsVoService;
import com.biz.crm.dms.business.stock.customer.sdk.strategy.StockStatisticsOperationTypeStrategy;
import com.biz.crm.dms.business.stock.customer.sdk.vo.StockStatisticsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class StockStatisticsVoServiceImpl
implements StockStatisticsVoService {
    @Autowired
    private List<StockStatisticsOperationTypeStrategy> stockStatisticsOperationTypeStrategies;
    @Autowired
    private AllowSaleListVoService allowSaleListVoService;
    @Autowired
    private ProductVoService productVoService;
    @Autowired
    private StockStatisticsRepository stockStatisticsRepository;
    @Autowired
    private CustomerVoService customerVoService;
    @Autowired
    private StockStatisticsDetailService stockStatisticsDetailService;
    @Autowired
    private StockStatisticsService stockStatisticsService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public void create(List<StockStatisticsDto> stockStatistics) {
        Validate.notEmpty(stockStatistics, (String)"\u5e93\u5b58\u63d0\u62a5\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(this.stockStatisticsOperationTypeStrategies, (String)"\u5e93\u5b58\u63d0\u62a5\uff0c\u672a\u67e5\u8be2\u5230\u64cd\u4f5c\u7c7b\u578b\u7b56\u7565\u5668", (Object[])new Object[0]);
        for (StockStatisticsDto dto : stockStatistics) {
            this.createValidate(dto);
        }
        List codes = stockStatistics.stream().map(e -> e.getCusCode().concat(e.getProductCode())).distinct().collect(Collectors.toList());
        Validate.isTrue((codes.size() == stockStatistics.size() ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u6570\u636e", (Object[])new Object[0]);
        Map<String, List<StockStatisticsDto>> collect = stockStatistics.stream().collect(Collectors.groupingBy(StockStatisticsDto::getOperationType));
        collect.forEach((k, v) -> {
            for (StockStatisticsOperationTypeStrategy stockStatisticsOperationTypeStrategy : this.stockStatisticsOperationTypeStrategies) {
                if (!stockStatisticsOperationTypeStrategy.getOperationTypeCode().equals(k)) continue;
                stockStatisticsOperationTypeStrategy.operationHandle(v);
            }
        });
    }

    public List<StockStatisticsVo> findDetailByCusCode(StockStatisticsDto statisticsDto) {
        if (Objects.isNull(statisticsDto) || StringUtils.isBlank((CharSequence)statisticsDto.getCusCode())) {
            return null;
        }
        String customerCode = statisticsDto.getCusCode();
        List<StockStatistics> stockStatisticsList = this.stockStatisticsService.findByCusCode(customerCode);
        List<StockStatisticsVo> byCusCode = new ArrayList();
        if (!CollectionUtils.isEmpty(stockStatisticsList)) {
            byCusCode = (List)this.nebulaToolkitService.copyCollectionByWhiteList(stockStatisticsList, StockStatistics.class, StockStatisticsVo.class, HashSet.class, ArrayList.class, new String[0]);
            List productCodes = byCusCode.stream().map(StockStatisticsVo::getProductCode).collect(Collectors.toList());
            List mainDetailsByProductCodes = this.productVoService.findMainDetailsByProductCodes(productCodes);
            if (CollectionUtils.isEmpty((Collection)mainDetailsByProductCodes)) {
                return byCusCode;
            }
            Map<String, ProductVo> collect = mainDetailsByProductCodes.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v));
            for (StockStatisticsVo vo : byCusCode) {
                ProductVo productVo = collect.get(vo.getProductCode());
                if (!Objects.nonNull(productVo)) continue;
                vo.setPrimaryPictureUrl(productVo.getPrimaryPictureUrl());
            }
            return byCusCode;
        }
        ValidateAllowSaleProductDto dto = new ValidateAllowSaleProductDto();
        dto.setBusinessCode(customerCode);
        dto.setListType(AllowSaleListTypeEnums.CUSTOMER.getCode());
        List allowSaleProductCodes = this.allowSaleListVoService.findAllowSaleProductCodes(dto);
        if (CollectionUtils.isEmpty((Collection)allowSaleProductCodes)) {
            return byCusCode;
        }
        List records = this.productVoService.findMainDetailsByProductCodes(allowSaleProductCodes);
        if (CollectionUtils.isEmpty((Collection)records)) {
            return byCusCode;
        }
        ArrayList<StockStatisticsVo> res = new ArrayList<StockStatisticsVo>();
        CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, customerCode);
        if (CollectionUtils.isEmpty((Collection)records)) {
            return byCusCode;
        }
        for (ProductVo record : records) {
            StockStatisticsVo statistics = new StockStatisticsVo();
            statistics.setCusCode(customerCode);
            statistics.setCusName(customerVo.getCustomerName());
            statistics.setStockQuantity(BigDecimal.ZERO);
            statistics.setProductCode(record.getProductCode());
            statistics.setProductName(record.getProductName());
            statistics.setProductUnit(record.getSaleUnit());
            statistics.setPrimaryPictureUrl(record.getPrimaryPictureUrl());
            statistics.setIsShelf(record.getIsShelf());
            if (Objects.nonNull(customerVo)) {
                statistics.setCusOrgCode(customerVo.getCustomerOrgCode());
                statistics.setCusOrgName(customerVo.getCustomerOrgName());
            }
            res.add(statistics);
        }
        return res;
    }

    private void createValidate(StockStatisticsDto dto) {
        Validate.notBlank((CharSequence)dto.getOperationSource(), (String)"\u64cd\u4f5c\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOperationType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAdjustType(), (String)"\u8c03\u6574\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCusCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOperationQuantity(), (String)"\u64cd\u4f5c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
    }
}

