/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.stock.customer.local.service.strategy.operation;

import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDto;
import com.biz.crm.dms.business.stock.customer.sdk.strategy.StockStatisticsAdjustTypeStrategy;
import com.biz.crm.dms.business.stock.customer.sdk.strategy.StockStatisticsOperationTypeStrategy;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StockStatisticsOperationTypeStrategyImpl
implements StockStatisticsOperationTypeStrategy {
    @Autowired
    private List<StockStatisticsAdjustTypeStrategy> stockStatisticsAdjustTypeStrategies;

    public String getOperationTypeCode() {
        return "stock_statistics";
    }

    public String getOperationTypeName() {
        return "\u5e93\u5b58\u63d0\u62a5";
    }

    public void operationHandle(List<StockStatisticsDto> stockStatisticsDto) {
        Validate.notNull(stockStatisticsDto, (String)"\u5e93\u5b58\u63d0\u62a5\uff0c\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(this.stockStatisticsAdjustTypeStrategies, (String)" \u5e93\u5b58\u63d0\u62a5\uff0c\u672a\u67e5\u8be2\u5230\u8c03\u6574\u7c7b\u578b\u7b56\u7565\u5668", (Object[])new Object[0]);
        Map<String, List<StockStatisticsDto>> collect = stockStatisticsDto.stream().collect(Collectors.groupingBy(StockStatisticsDto::getAdjustType));
        collect.forEach((k, v) -> {
            for (StockStatisticsAdjustTypeStrategy stockStatisticsAdjustTypeStrategy : this.stockStatisticsAdjustTypeStrategies) {
                if (!stockStatisticsAdjustTypeStrategy.getAdjustTypeCode().equals(k)) continue;
                stockStatisticsAdjustTypeStrategy.adjustHandle(v);
            }
        });
    }
}

