package com.biz.crm.dms.business.stock.customer.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDto;
import com.biz.crm.dms.business.stock.customer.sdk.vo.StockStatisticsVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年07月26日 16:21:00
 */
public interface StockStatisticsVoService {

  /**
   * 库存提报
   *
   * @param stockStatisticsVos
   * @return
   */
  void create(List<StockStatisticsDto> stockStatisticsVos);

  /**
   * 库存提报页面查询分页
   * @param dto
   * @return
   */
  List<StockStatisticsVo> findDetailByCusCode(StockStatisticsDto dto);

  /**
   * 库存提报分页查询
   * @param pageable 分页对象
   * @param dto 参数dto
   * @return 库存提报数据
   */
  Page<StockStatisticsVo> findByStockStatisticsDto(Pageable pageable, StockStatisticsDto dto);
}
