package com.biz.crm.dms.business.stock.customer.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author HanJiaJun
 * @describe: 库存提报明细Vo
 * @createTime 2022年07月26日 16:00:00
 */
@Data
@ApiModel(value = "库存提报明细Vo")
public class StockStatisticsDetailVo extends UuidFlagOpVo {


  /**
   * 操作来源
   */
  @ApiModelProperty(name = "OperationSource", value = "操作来源", required = true)
  private String operationSource;

  /**
   * 操作类型
   */
  @ApiModelProperty(name = "OperationType", value = "操作类型", required = true)
  private String operationType;

  /**
   * 调整类型
   */
  @ApiModelProperty(name = "adjustType", value = "调整类型", required = true)
  private String adjustType;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "cusCode", value = "客户编码", required = true)
  private String cusCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(name = "cusName", value = "客户名称", required = true)
  private String cusName;

  /**
   * 商品编码
   */
  @ApiModelProperty(name = "productCode", value = "商品编码", required = true)
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty(name = "productName", value = "商品名称", required = true)
  private String productName;

  /**
   * 商品单位
   */
  @ApiModelProperty(name = "productUnit", value = "商品单位", required = true)
  private String productUnit;

  /**
   * 操作数量
   */
  @ApiModelProperty(name = "operationQuantity", value = "操作数量", required = true)
  private BigDecimal operationQuantity;

  /**
   * 操作后数量
   */
  @ApiModelProperty(name = "quantity", value = "操作后数量", required = true)
  private BigDecimal quantity;

  /**
   * 关联单据编码
   */
  @ApiModelProperty(name = "orderCode", value = "关联单据编码", required = true)
  private String orderCode;

  /**
   * 操作人（创建人）所属组织编码
   */
  @ApiModelProperty(name = "cusOrgCode", value = "操作人（创建人）所属组织编码", required = true)
  private String operationOrgCode;

  /**
   * 操作人（创建人）所属组织名称
   */
  @ApiModelProperty(name = "cusOrgName", value = "操作人（创建人）所属组织名称", required = true)
  private String operationOrgName;

  /**
   * 操作人（创建人）职位编码
   */
  @ApiModelProperty(name = "operationPositionCode", value = "操操作人（创建人）职位编码", required = true)
  private String operationPositionCode;

  /**
   * 操作人（创建人）职位名称
   */
  @ApiModelProperty(name = "operationPositionName", value = "操作人（创建人）职位名称", required = true)
  private String operationPositionName;

  /**
   * 操作时间（当前时间因要与主表保持一致，故不使用创建时间）
   */
  @ApiModelProperty(name = "operationTime", value = "操作时间", required = true)
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date operationTime;
}
