package com.biz.crm.dms.business.stock.customer.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author HanJiaJun
 * @describe: 库存提报主表Vo
 * @createTime 2022年07月25日 16:29:00
 */
@Data
public class StockStatisticsVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 265214412457786598L;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "cusCode", value = "客户编码", required = true)
  private String cusCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(name = "cusName", value = "客户名称", required = true)
  private String cusName;

  /**
   * 客户所属组织编码
   */
  @ApiModelProperty(name = "cusOrgCode", value = "客户所属组织编码", required = true)
  private String cusOrgCode;

  /**
   * 客户所属组织名称
   */
  @ApiModelProperty(name = "cusOrgName", value = "客户所属组织名称", required = true)
  private String cusOrgName;
  /**
   * 商品编码
   */
  @ApiModelProperty(name = "productCode", value = "商品编码", required = true)
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty(name = "productName", value = "商品名称", required = true)
  private String productName;

  /**
   * 商品单位
   */
  @ApiModelProperty(name = "productUnit", value = "商品单位", required = true)
  private String productUnit;

  /**
   * 库存量
   */
  @ApiModelProperty(name = "stockQuantity", value = "库存量", required = true)
  private BigDecimal stockQuantity;


  /** 主图片url */
  @ApiModelProperty("商品主图片url")
  private String primaryPictureUrl;


  /** 上下架状态 */
  @ApiModelProperty("商品上下架状态")
  private String isShelf;

  /**
   * 库存时间
   */
  @ApiModelProperty(name = "stockTime", value = "库存时间", required = true)
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date stockTime;
}
