package com.biz.crm.dms.business.stock.customer.sdk.dto;

import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年07月28日 15:29:00
 */
@Data
@ApiModel(value = "库存提报分页查询Dto")
public class StockStatisticsPageDto extends UuidFlagOpVo {

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "cusCode", value = "客户编码", required = true)
  private String cusCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(name = "cusName", value = "客户名称", required = true)
  private String cusName;

  /**
   * 商品编码
   */
  @ApiModelProperty(name = "productCode", value = "商品编码", required = true)
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty(name = "productName", value = "商品名称", required = true)
  private String productName;

  /**
   * 库存时间yyyy-MM-dd
   */
  @ApiModelProperty(name = "stockTime", value = "库存时间yyyy-MM-dd", required = true)
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date stockTime;

  /**
   * 客户所属企业组织编码
   */
  @ApiModelProperty(name = "cusOrgCode", value = "客户所属企业组织编码", required = true)
  private String cusOrgCode;

  /**
   * 客户所属企业组织编码
   */
  @ApiModelProperty(name = "cusOrgName", value = "客户所属企业组织编码", required = true)
  private String cusOrgName;
}
