package com.biz.crm.dms.feign.customer.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerAddressVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author sunx
 * @date 2021/11/15
 */
@Slf4j
@Api(tags = "客户信息: CustomerAddressVo: feign调用测试")
@RestController
@RequestMapping(value = {"/v1/customerAddress/test"})
@Deprecated
public class CustomerAddressVoTestController {

  @Autowired
  private CustomerAddressVoService customerAddressVoService;

  @ApiOperation(value = "通过ID获取客户收货地址详细信息")
  @GetMapping("/findDetailsById")
  public Result<?> findDetailsById(
      @RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(customerAddressVoService.findDetailsById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
