package com.biz.crm.dms.feign.customer.local.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.customer.local.feign.internal.CustomerAddressVoServiceFeignImpl;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerAddressVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 客户收货地址feign
 *
 * @author sunx
 * @date 2021/11/15
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = CustomerAddressVoServiceFeignImpl.class)
public interface CustomerAddressVoServiceFeign {

  /**
   * 通过ID获取客户收货地址详细信息
   *
   * @param id 收货地址ID
   * @return 客户收货地址信息
   */
  @GetMapping("/v1/customerAddress/customerAddress/findDetailsById")
  Result<CustomerAddressVo> findDetailsById(
      @RequestParam(value = "id", required = false) String id);
}
