package com.biz.crm.dms.feign.customer.local.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.customer.local.feign.internal.CustomerVoServiceFeignImpl;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;

import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 客户feign
 *
 * @author sunx
 * @date 2021/11/15
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = CustomerVoServiceFeignImpl.class)
public interface CustomerVoServiceFeign {

  /**
   * 通过客户ID或者客户编码查询客户信息详情(包含客户信息所有关联数据)
   *
   * @param id
   * @param customerCode
   */
  @GetMapping("/v1/customer/customer/findDetailsByIdOrCode")
  Result<CustomerVo> findDetailsByIdOrCode(
      @RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID")
          String id,
      @RequestParam(value = "customerCode", required = false)
          @ApiParam(name = "customerCode", value = "客户编码")
          String customerCode);

  /**
   * 根据企业组织编码获取匹配的客户信息
   *
   * @param orgCodeList
   * @return
   */
  @GetMapping("/v1/customer/customer/findByOrgCodes")
  Result<List<CustomerVo>> findByOrgCodes(@RequestParam("orgCodeList") List<String> orgCodeList);

  /**
   * 根据客户编码集合获取对应的客户信息
   *
   * @param customerCodeList
   * @return
   */
  @GetMapping("/v1/customer/customer/findByCustomerCodes")
  Result<List<CustomerVo>> findByCustomerCodes(
      @RequestParam("customerCodeList") List<String> customerCodeList);

  /**
   * 根据客户编码集合获取对应的客户信息-包含主信息+组织信息
   *
   * @param customerCodeSet 客户编码集合
   * @return 客户信息集合
   */
  @GetMapping("/v1/customer/customer/findForPriceByCustomerCodes")
  Result<List<CustomerVo>> findForPriceByCustomerCodes(
      @RequestParam("customerCodeSet") Set<String> customerCodeSet);

  /**
   * 根据渠道编码集合获取对应的客户信息
   *
   * @param channelList 渠道集合
   * @return 客户信息集合
   */
  @GetMapping("/v1/customer/customer/findByChannels")
  Result<List<CustomerVo>> findByChannels(@RequestParam("channelList") List<String> channelList);

  /**
   * 根据客户类型集合获取对应的客户信息
   *
   * @param typeList 客户类型集合
   * @return 客户信息集合
   */
  @GetMapping("/v1/customer/customer/findByTypes")
  Result<List<CustomerVo>> findByTypes(@RequestParam("typeList") List<String> typeList);
}
