package com.biz.crm.dms.feign.customer.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.customer.local.feign.CustomerVoServiceFeign;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import feign.hystrix.FallbackFactory;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

/**
 * 客户feign熔断实现
 * @author sunx
 * @date 2021/11/15
 */
@Component
public class CustomerVoServiceFeignImpl implements FallbackFactory<CustomerVoServiceFeign> {

  @Override
  public CustomerVoServiceFeign create(Throwable throwable) {
    return new CustomerVoServiceFeign() {
      @Override
      public Result<CustomerVo> findDetailsByIdOrCode(String id, String customerCode) {
        throw new UnsupportedOperationException("通过客户ID或者客户编码查询客户信息详情熔断");
      }

      @Override
      public Result<List<CustomerVo>> findByOrgCodes(List<String> orgCodeList) {
        throw new UnsupportedOperationException("根据企业组织编码获取匹配的客户信息熔断");
      }

      @Override
      public Result<List<CustomerVo>> findByCustomerCodes(List<String> customerCodeList) {
        throw new UnsupportedOperationException("根据客户编码集合获取对应的客户信息熔断");
      }

      @Override
      public Result<List<CustomerVo>> findForPriceByCustomerCodes(Set<String> customerCodeSet) {
        throw new UnsupportedOperationException("根据客户编码集合获取对应的客户信息-包含主信息+组织信息熔断");
      }

      @Override
      public Result<List<CustomerVo>> findByChannels(List<String> channelList) {
        throw new UnsupportedOperationException("根据渠道编码集合获取对应的客户信息熔断");
      }

      @Override
      public Result<List<CustomerVo>> findByTypes(List<String> typeList) {
        throw new UnsupportedOperationException("根据客户类型集合获取对应的客户信息熔断");
      }
    };
  }
}
