package com.biz.crm.dms.feign.customer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.customer.local.feign.CustomerVoServiceFeign;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSelectDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;

import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 客户sdk实现
 *
 * @author sunx
 * @date 2021/11/15
 */
@Service
public class CustomerVoServiceImpl implements CustomerVoService {

  @Autowired private CustomerVoServiceFeign customerVoServiceFeign;

  @Override
  public CustomerVo findDetailsByIdOrCode(String id, String customerCode) {
    Result<CustomerVo> result = this.customerVoServiceFeign.findDetailsByIdOrCode(id, customerCode);
    return result.getResult();
  }

  @Override
  public Page<CustomerVo> findByCustomerSelectDto(Pageable pageable, CustomerSelectDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<CustomerVo> findByOrgCodes(List<String> orgCodeList) {
    return this.customerVoServiceFeign.findByOrgCodes(orgCodeList).getResult();
  }

  @Override
  public List<CustomerVo> findByCustomerCodes(List<String> customerCodeList) {
    return this.customerVoServiceFeign.findByCustomerCodes(customerCodeList).getResult();
  }

  @Override
  public List<CustomerVo> findForPriceByCustomerCodes(Set<String> customerCodeSet) {
    return this.customerVoServiceFeign.findForPriceByCustomerCodes(customerCodeSet).getResult();
  }

  @Override
  public List<CustomerVo> findByChannels(List<String> channelList) {
    return this.customerVoServiceFeign.findByChannels(channelList).getResult();
  }

  @Override
  public List<CustomerVo> findByTypes(List<String> typeList) {
    return this.customerVoServiceFeign.findByTypes(typeList).getResult();
  }
}
