package com.biz.crm.dms.feign.material.local.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.material.local.feign.internal.MaterialVoServiceFeignImpl;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * 物料feign
 *
 * @author sunx
 * @date 2021/11/16
 */
@FeignClient(name = "${mdm.feign-client.name:crm-mdm}", path = "crm-mdm", fallbackFactory = MaterialVoServiceFeignImpl.class)
public interface MaterialVoServiceFeign {

  /**
   * 根据物料编码查询详情
   *
   * @param materialCode
   * @return
   */
  @GetMapping("/v1/material/material/findDetailByMaterialCode")
  Result<MaterialVo> findDetailByMaterialCode(
      @RequestParam(value = "materialCode") String materialCode);

  /**
   * 根据物料编码集合查询详情
   *
   * @param materialCodes
   * @return
   */
  @GetMapping("/v1/material/material/findDetailByMaterialCodes")
  Result<List<MaterialVo>> findDetailByMaterialCodes(
      @RequestParam(value = "materialCodes") Set<String> materialCodes);
}
