package com.biz.crm.dms.feign.material.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.feign.material.local.feign.MaterialVoServiceFeign;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialDto;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import java.util.List;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 物料sdk实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Service
public class MaterialVoServiceImpl implements MaterialVoService {

  @Autowired
  private MaterialVoServiceFeign materialVoServiceFeign;

  @Override
  public Page<MaterialVo> findByConditions(Pageable pageable, MaterialDto materialDto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public MaterialVo findDetailById(String id) {
    throw new UnsupportedOperationException();
  }

  @Override
  public MaterialVo findDetailByMaterialCode(String materialCode) {
    return materialVoServiceFeign.findDetailByMaterialCode(materialCode).getResult();
  }

  @Override
  public List<MaterialVo> findDetailByMaterialCodes(Set<String> materialCodes) {
    if (CollectionUtils.isEmpty(materialCodes)) {
      return null;
    }
    return materialVoServiceFeign.findDetailByMaterialCodes(materialCodes).getResult();
  }

  @Override
  public void save(MaterialDto materialDto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void update(MaterialDto materialDto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void deleteBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void enableBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void disableBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }
}
