package com.biz.crm.dms.feign.org.local.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.org.local.feign.internal.OrgVoFeignImpl;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 组织基本信息feign
 * @author sunx
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = OrgVoFeignImpl.class)
public interface OrgVoFeign {

  /**
   * 根据组织编码查询全部上级（含当前）组织列表
   *
   * @param orgCode
   * @return
   */
  @GetMapping("/v1/org/org/findAllParentByOrgCode")
  Result<List<OrgVo>> findAllParentByOrgCode(@RequestParam("orgCode") String orgCode);

  /**
   * 按orgCode集合查询
   *
   * @param orgCodeList
   * @return
   */
  @GetMapping(value = {"/v1/org/org/findByOrgCodes"})
  Result<List<OrgVo>> findByOrgCodes(@RequestParam("orgCodeList") List<String> orgCodeList);

  /**
   * 根据组织编码集合查询全部上级（含当前）组织列表
   *
   * @param orgCodes
   * @return
   */
  @GetMapping(value = {"/v1/org/org/findAllParentByOrgCodes"})
  Result<List<OrgVo>> findAllParentByOrgCodes(@RequestParam("orgCodes") List<String> orgCodes);
}