package com.biz.crm.dms.feign.org.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.org.local.feign.OrgRegionVoFeign;
import com.biz.crm.mdm.business.org.sdk.vo.OrgRegionVo;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 组织行政区域feign熔断实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Component
public class OrgRegionVoFeignImpl implements FallbackFactory<OrgRegionVoFeign> {

  @Override
  public OrgRegionVoFeign create(Throwable throwable) {
    return new OrgRegionVoFeign() {
      @Override
      public Result<List<OrgRegionVo>> findByOrgCode(String orgCode) {
        throw new UnsupportedOperationException("查询组织关联的行政区域列表熔断");
      }
    };
  }
}
