package com.biz.crm.dms.feign.org.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.org.local.feign.OrgVoFeign;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @program: 组织行基本信息feign熔断实现
 * @description:
 * @author: Bao Hongbin
 * @create: 2021-11-24 11:22
 */
@Component
public class OrgVoFeignImpl implements FallbackFactory<OrgVoFeign> {

  @Override
  public OrgVoFeign create(Throwable throwable) {
    return new OrgVoFeign() {

      @Override
      public Result<List<OrgVo>> findAllParentByOrgCode(String orgCode) {
        throw new UnsupportedOperationException("根据组织编码查询全部上级（含当前）组织列表熔断");
      }

      @Override
      public Result<List<OrgVo>> findByOrgCodes(List<String> orgCodeList) {
        throw new UnsupportedOperationException("按orgCode集合查询熔断");
      }

      @Override
      public Result<List<OrgVo>> findAllParentByOrgCodes(List<String> orgCodes) {
        throw new UnsupportedOperationException("根据组织编码集合查询全部上级（含当前）组织列表熔断");
      }
    };
  }
}
