package com.biz.crm.dms.feign.org.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.feign.org.local.feign.OrgVoFeign;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/** 组织基本信息sdk实现 */
@Service
public class OrgVoServiceImpl implements OrgVoService {

  @Autowired private OrgVoFeign orgVoFeign;

  @Override
  public Page<OrgVo> findByConditions(Pageable pageable, OrgPaginationDto paginationDto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public OrgVo findDetailsById(String id) {
    throw new UnsupportedOperationException();
  }

  @Override
  public OrgVo findByOrgCode(String orgCode) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<OrgVo> findDetailsByIds(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<OrgVo> findByOrgCodes(List<String> orgCodes) {
    return this.orgVoFeign.findByOrgCodes(orgCodes).getResult();
  }

  @Override
  public List<OrgVo> findAllChildrenById(String id) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<OrgVo> findAllChildrenByOrgCode(String orgCode) {
    throw new UnsupportedOperationException();
  }

  /**
   * 通过企业组织编码查询其所有上级及其本身
   *
   * @param orgCode 企业组织编码
   * @return List<OrgVo> 其所有上级及其本身集合
   */
  @Override
  public List<OrgVo> findAllParentByOrgCode(String orgCode) {
    if (!StringUtils.isNotBlank(orgCode)) {
      return null;
    }
    return orgVoFeign.findAllParentByOrgCode(orgCode).getResult();
  }

  /**
   * 根据 组织编码集合查询 全部上级（含当前）组织列表
   *
   * @param orgCodes
   * @return
   */
  @Override
  public List<OrgVo> findAllParentByOrgCodes(List<String> orgCodes) {
    if (CollectionUtils.isEmpty(orgCodes)) {
      return null;
    }
    return orgVoFeign.findAllParentByOrgCodes(orgCodes).getResult();
  }
}
