package com.biz.crm.dms.feign.price.local.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.price.local.feign.internal.PriceModelVoServiceFeignImpl;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 价格管理feign
 *
 * @author sunx
 * @date 2022/1/6
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = PriceModelVoServiceFeignImpl.class)
public interface PriceModelVoServiceFeign {

  /**
   * 查询价格
   *
   * @param dto
   * @return
   */
  @PostMapping(value = {"/v1/price/price/handleSearchPrice"})
  Result<Map<String, PriceModelVo>> handleSearchPrice(@RequestBody SearchPriceDto dto);

  /**
   * 询价
   *
   * @param dto
   * @return
   */
  @PostMapping(value = {"/v1/price/price/findPrice"})
  Result<Map<String, PriceModelVo>> findPrice(@RequestBody FindPriceDto dto);
}
