package com.biz.crm.dms.feign.price.local.service.internal;

import com.biz.crm.dms.feign.price.local.feign.PriceModelVoServiceFeign;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 询价sdk接口实现
 *
 * @author sunx
 * @date 2022/1/6
 */
@Service
public class PriceModelVoServiceImpl implements PriceModelVoService {

  @Autowired private PriceModelVoServiceFeign priceModelVoServiceFeign;

  @Override
  public Map<String, PriceModelVo> handleSearchPrice(SearchPriceDto dto) {
    return this.priceModelVoServiceFeign.handleSearchPrice(dto).getResult();
  }

  @Override
  public Map<String, PriceModelVo> findPrice(FindPriceDto dto) {
    return this.priceModelVoServiceFeign.findPrice(dto).getResult();
  }
}
