package com.biz.crm.dms.feign.product.level.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.product.level.local.feign.ProductLevelVoSdkServiceFeign;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import feign.hystrix.FallbackFactory;
import java.util.Set;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 商品层级feign熔断实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Component
public class ProductLevelVoSdkServiceFeignImpl
    implements FallbackFactory<ProductLevelVoSdkServiceFeign> {

  @Override
  public ProductLevelVoSdkServiceFeign create(Throwable throwable) {
    return new ProductLevelVoSdkServiceFeign() {

      @Override
      public Result<List<ProductLevelVo>> findListByCodes(List<String> codes) {
        throw new UnsupportedOperationException("根据层级编码获取商品层级明细信息熔断");
      }

      @Override
      public Result<List<String>> findCurAndChildrenCodesByCodes(Set<String> productLevelCodes) {
        throw new UnsupportedOperationException("据产品层级编码查询该产品层级及全部下级层级的编码熔断");
      }

      @Override
      public Result<Map<String, List<ProductLevelVo>>> findCurAndParentByCodes(List<String> codes) {
        throw new UnsupportedOperationException("根据层级编码获取当前层级及上级明细信息熔断");
      }
    };
  }
}
