package com.biz.crm.dms.feign.product.local.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.product.local.feign.internal.ProductVoServiceFeignImpl;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 商品feign
 *
 * @author sunx
 * @date 2021/11/16
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = ProductVoServiceFeignImpl.class)
public interface ProductVoServiceFeign {

  /**
   * 根据商品商品id集合或编码集合获取商品信息
   *
   * @param ids
   * @param codes
   * @return
   */
  @GetMapping("/v1/product/product/findDetailsByIdsOrCodes")
  Result<List<ProductVo>> findDetailsByIdsOrCodes(
      @RequestParam("ids") List<String> ids, @RequestParam("codes") List<String> codes);

  /**
   * 根据商品层级获取对应的商品信息
   *
   * @param productLevelCodeList
   * @return
   */
  @GetMapping("/v1/product/product/findByProductLevelCodes")
  Result<List<ProductVo>> findByProductLevelCodes(
      @RequestParam("productLevelCodeList") List<String> productLevelCodeList);

  /**
   * 根据spu编码获取对应的商品信息
   *
   * @param spuCodeList
   * @return
   */
  @GetMapping("/v1/product/product/findBySpuCodes")
  Result<List<ProductVo>> findBySpuCodes(@RequestParam("spuCodeList") List<String> spuCodeList);

  /**
   * 根据商品商品编码集合获取商品主信息+层级信息
   *
   * @param productCodeList
   * @return
   */
  @GetMapping(value = {"/v1/product/product/findMainDetailsByProductCodes"})
  Result<List<ProductVo>> findMainDetailsByProductCodes(
      @RequestParam("productCodeList") List<String> productCodeList);
}
