package com.biz.crm.dms.feign.product.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.product.local.feign.ProductVoServiceFeign;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 商品feign熔断实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Component
public class ProductVoServiceFeignImpl implements FallbackFactory<ProductVoServiceFeign> {

  @Override
  public ProductVoServiceFeign create(Throwable throwable) {
    return new ProductVoServiceFeign() {
      @Override
      public Result<List<ProductVo>> findDetailsByIdsOrCodes(List<String> ids, List<String> codes) {
        throw new UnsupportedOperationException("根据商品商品id集合或编码集合获取商品信息熔断");
      }

      @Override
      public Result<List<ProductVo>> findByProductLevelCodes(List<String> productLevelCodeList) {
        throw new UnsupportedOperationException("根据商品层级获取对应的商品信息熔断");
      }

      @Override
      public Result<List<ProductVo>> findBySpuCodes(List<String> spuCodeList) {
        throw new UnsupportedOperationException("根据spu编码获取对应的商品信息熔断");
      }

      @Override
      public Result<List<ProductVo>> findMainDetailsByProductCodes(List<String> productCodeList) {
        throw new UnsupportedOperationException("根据商品商品编码集合获取商品主信息+层级信息熔断");
      }
    };
  }
}
