package com.biz.crm.dms.feign.product.local.service.internal;

import com.biz.crm.dms.feign.product.local.feign.ProductVoServiceFeign;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * 商品sdk实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Service
public class ProductVoServiceImpl implements ProductVoService {

  @Autowired private ProductVoServiceFeign productVoServiceFeign;

  @Override
  public List<ProductVo> findDetailsByIdsOrProductCodes(
      List<String> ids, List<String> productCodes) {
    ids = Optional.ofNullable(ids).orElse(Lists.newLinkedList());
    productCodes = Optional.ofNullable(productCodes).orElse(Lists.newLinkedList());
    return this.productVoServiceFeign.findDetailsByIdsOrCodes(ids, productCodes).getResult();
  }

  @Override
  public ProductVo create(ProductDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public ProductVo update(ProductDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<ProductVo> findByProductLevelCodes(List<String> productLevelCodeList) {
    productLevelCodeList = Optional.ofNullable(productLevelCodeList).orElse(Lists.newLinkedList());
    return this.productVoServiceFeign.findByProductLevelCodes(productLevelCodeList).getResult();
  }

  @Override
  public List<ProductVo> findBySpuCodes(List<String> spuCodeList) {
    spuCodeList = Optional.ofNullable(spuCodeList).orElse(Lists.newLinkedList());
    return this.productVoServiceFeign.findBySpuCodes(spuCodeList).getResult();
  }

  @Override
  public List<ProductVo> findMainDetailsByProductCodes(List<String> productCodeList) {
    productCodeList = Optional.ofNullable(productCodeList).orElse(Lists.newLinkedList());
    return this.productVoServiceFeign.findMainDetailsByProductCodes(productCodeList).getResult();
  }
}
