package com.biz.crm.dms.feign.product.spu.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.product.spu.local.feign.ProductSpuRelateSkuVoServiceFeign;
import com.biz.crm.mdm.business.product.spu.sdk.vo.FavoriteProductVO;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 商品spu关联sku feign实现
 *
 * @author sunx
 * @date 2021/12/3
 */
@Component
public class ProductSpuRelateSkuVoServiceFeignImpl
    implements FallbackFactory<ProductSpuRelateSkuVoServiceFeign> {

  @Override
  public ProductSpuRelateSkuVoServiceFeign create(Throwable cause) {
    return new ProductSpuRelateSkuVoServiceFeign() {
      @Override
      public Result<List<ProductSpuRelateSkuVo>> findBySpuCodes(List<String> spuCodeList) {
        throw new UnsupportedOperationException("根据spuCode集合获取关联sku信息熔断");
      }

      @Override
      public Result<List<FavoriteProductVO>> findDetailBySpuCodes(List<String> spuCodeList) {
        throw new UnsupportedOperationException("根据spuCode集合获取关联sku的商品信息");
      }
    };
  }
}
