package com.biz.crm.dms.feign.product.spu.local.service.internal;

import com.biz.crm.dms.feign.product.spu.local.feign.ProductSpuRelateSkuVoServiceFeign;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuRelateSkuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.FavoriteProductVO;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * spu关联sku sdk实现
 *
 * @author sunx
 * @date 2021/12/3
 */
@Service
public class ProductSpuRelateSkuVoServiceImpl implements ProductSpuRelateSkuVoService {

  @Autowired private ProductSpuRelateSkuVoServiceFeign productSpuRelateSkuVoServiceFeign;

  @Override
  public List<ProductSpuRelateSkuVo> findBySpuCodes(List<String> spuCodeList) {
    spuCodeList = Optional.ofNullable(spuCodeList).orElse(Lists.newLinkedList());
    return this.productSpuRelateSkuVoServiceFeign.findBySpuCodes(spuCodeList).getResult();
  }

  public List<FavoriteProductVO> findDetailBySpuCodes(List<String> spuCodeList) {
    spuCodeList = Optional.ofNullable(spuCodeList).orElse(Lists.newLinkedList());
    return this.productSpuRelateSkuVoServiceFeign.findDetailBySpuCodes(spuCodeList).getResult();
  }
}
