package com.biz.crm.dms.feign.terminal.local.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.terminal.local.feign.internal.TerminalSupplyVoServiceFeignImpl;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 终端供货关系feign
 *
 * @author sunx
 * @date 2021/11/16
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = TerminalSupplyVoServiceFeignImpl.class)
public interface TerminalSupplyVoServiceFeign {

  /**
   * 根据终端编码集合获取匹配信息
   *
   * @param codes
   * @return
   */
  @GetMapping("/v1/terminal/terminalSupply/findByTerminalCodes")
  Result<List<TerminalSupplyVo>> findByTerminalCodes(@RequestParam("codes") List<String> codes);
}
