package com.biz.crm.dms.feign.terminal.local.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.terminal.local.feign.internal.TerminalVoServiceFeignImpl;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 终端feign
 *
 * @author sunx
 * @date 2021/11/16
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = TerminalVoServiceFeignImpl.class)
public interface TerminalVoServiceFeign {

  /**
   * 根据id或编码集合获取终端详情
   *
   * @param ids
   * @param codes
   * @return
   */
  @GetMapping("/v1/terminal/terminal/findDetailByIdsOrCodes")
  Result<List<TerminalVo>> findDetailByIdsOrCodes(
      @RequestParam("ids") List<String> ids, @RequestParam("codes") List<String> codes);

  /**
   * 根据企业组织编码获取匹配的终端信息
   *
   * @param orgCodeList
   * @return
   */
  @GetMapping("/v1/terminal/terminal/findByOrgCodes")
  Result<List<TerminalVo>> findByOrgCodes(@RequestParam("orgCodeList") List<String> orgCodeList);

  /**
   * 根据编码获取终端主信息+组织信息
   *
   * @param terminalCodeList
   * @return
   */
  @GetMapping("/v1/terminal/terminal/findMainDetailsByTerminalCodes")
  Result<List<TerminalVo>> findMainDetailsByTerminalCodes(
      @RequestParam("terminalCodeList") List<String> terminalCodeList);
}
