package com.biz.crm.dms.feign.terminal.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.terminal.local.feign.TerminalRelaOrgVoServiceFeign;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 终端组织关系feign熔断实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Component
public class TerminalRelaOrgVoServiceFeignImpl
    implements FallbackFactory<TerminalRelaOrgVoServiceFeign> {

  @Override
  public TerminalRelaOrgVoServiceFeign create(Throwable throwable) {
    return new TerminalRelaOrgVoServiceFeign() {
      @Override
      public Result<List<TerminalRelaOrgVo>> findByOrgCodes(List<String> orgCodeList) {
        throw new UnsupportedOperationException("根据企业组织编码获取匹配的终端信息熔断");
      }
    };
  }
}
