package com.biz.crm.dms.feign.terminal.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.terminal.local.feign.TerminalSupplyVoServiceFeign;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 终端供货关系feign熔断实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Component
public class TerminalSupplyVoServiceFeignImpl
    implements FallbackFactory<TerminalSupplyVoServiceFeign> {

  @Override
  public TerminalSupplyVoServiceFeign create(Throwable throwable) {
    return new TerminalSupplyVoServiceFeign() {
      @Override
      public Result<List<TerminalSupplyVo>> findByTerminalCodes(List<String> codes) {
        throw new UnsupportedOperationException("根据终端编码集合获取匹配信息熔断");
      }
    };
  }
}
