package com.biz.crm.dms.feign.terminal.local.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.feign.terminal.local.feign.TerminalVoServiceFeign;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 终端feign熔断实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Component
public class TerminalVoServiceFeignImpl implements FallbackFactory<TerminalVoServiceFeign> {

  @Override
  public TerminalVoServiceFeign create(Throwable throwable) {
    return new TerminalVoServiceFeign() {
      @Override
      public Result<List<TerminalVo>> findDetailByIdsOrCodes(List<String> ids, List<String> codes) {
        throw new UnsupportedOperationException("根据id或编码集合获取终端详情熔断");
      }

      @Override
      public Result<List<TerminalVo>> findByOrgCodes(List<String> orgCodeList) {
        throw new UnsupportedOperationException("根据组织编码集合获取终端详情熔断");
      }

      @Override
      public Result<List<TerminalVo>> findMainDetailsByTerminalCodes(
          List<String> terminalCodeList) {
        throw new UnsupportedOperationException("根据编码获取终端主信息+组织信息熔断");
      }
    };
  }
}
