package com.biz.crm.dms.feign.terminal.local.service.internal;

import com.biz.crm.dms.feign.terminal.local.feign.TerminalVoServiceFeign;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * 终端sdk实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Service
public class TerminalVoServiceImpl implements TerminalVoService {

  @Autowired private TerminalVoServiceFeign terminalVoServiceFeign;

  @Override
  public List<TerminalVo> findDetailsByIdsOrTerminalCodes(
      List<String> ids, List<String> terminalCodes) {
    ids = Optional.ofNullable(ids).orElse(Lists.newLinkedList());
    terminalCodes = Optional.ofNullable(terminalCodes).orElse(Lists.newLinkedList());
    return this.terminalVoServiceFeign.findDetailByIdsOrCodes(ids, terminalCodes).getResult();
  }

  @Override
  public TerminalVo create(TerminalDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public TerminalVo update(TerminalDto dto) {
    throw new UnsupportedOperationException();
  }


  public List<TerminalVo> findMainDetailsByTerminalCodes(List<String> terminalCodeList) {
    terminalCodeList = Optional.ofNullable(terminalCodeList).orElse(Lists.newLinkedList());
    return this.terminalVoServiceFeign.findMainDetailsByTerminalCodes(terminalCodeList).getResult();
  }
}
