package com.biz.crm.ems.admin.web.config;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import java.util.Objects;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * @author hecheng
 * @description: 新版分页兼容旧版分页PageResult 当方法上存在注解Deprecated时， 且返回值泛型为Page时把分页结构处理为PageResult结构
 * @date 2021/9/28 上午11:36
 */
@ControllerAdvice
@Slf4j
public class MdmResponseBodyAdvice implements ResponseBodyAdvice {


  @SneakyThrows
  @Override
  public Object beforeBodyWrite(Object returnValue, MethodParameter methodParameter,
          MediaType mediaType, Class aclass, ServerHttpRequest serverHttpRequest,
          ServerHttpResponse serverHttpResponse) {
    Result result = (Result) returnValue;
    Object data = result.getResult();
    if (Objects.isNull(data)) {
      return returnValue;
    }
    Class<?> dataClass = data.getClass();
    Deprecated deprecated = methodParameter.getMethodAnnotation(Deprecated.class);
    if (deprecated != null && Deprecated.class.isAssignableFrom(deprecated.getClass()) && Page.class.isAssignableFrom(dataClass)) {
      Page dataPage = (Page) data;
      JSONObject jsonObject = new JSONObject();
      jsonObject.put("data", dataPage.getRecords());
      jsonObject.put("count", dataPage.getTotal());
      result.setResult(jsonObject);
      return result;
    }
    return returnValue;
  }

  @SneakyThrows
  @Override
  public boolean supports(MethodParameter methodParameter, Class aClass) {
    //获取当前处理请求的controller的方法
    Class<?> returnTypeClass = methodParameter.getMethod().getReturnType();
    return Result.class.isAssignableFrom(returnTypeClass);
  }
}
