package com.biz.crm.ems.admin.web.notifier;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.mdm.business.login.log.sdk.dto.LoginLogDto;
import com.biz.crm.mdm.business.login.log.sdk.service.LoginLogVoService;
import com.bizunited.nebula.security.sdk.event.AuthenticatedEventListener;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

/**
 * spring security鉴权后会被触发的事件
 *
 * @author pengxi
 */
@Slf4j
@Component("AuthenticatedEventListenerImpl")
public class AuthenticatedEventListenerImpl implements AuthenticatedEventListener {

  @Autowired
  private LoginLogVoService loginLogVoService;

  @Override
  public void onAuthenticationSuccess(LoginDetails loginDetails, Authentication authentication) {
    // 当登录成功后，创建登录日志
    if (loginDetails instanceof LoginUserDetailsForEMS) {
      LoginUserDetailsForEMS loginUserDetails = (LoginUserDetailsForEMS) loginDetails;
      LoginLogDto loginLogDto = new LoginLogDto();
      loginLogDto.setAppType(loginUserDetails.getAppType());
      loginLogDto.setLoginType(loginUserDetails.getType());
      loginLogDto.setUsertype(loginUserDetails.getUsertype());
      loginLogDto.setAccount(loginUserDetails.getAccount());
      loginLogDto.setFullName(loginUserDetails.getUsername());
      this.loginLogVoService.create(loginLogDto);
    } else {
      log.error("security鉴权成功后，因登录实体类型转换不匹配，导致未创建登录日志！");
    }
  }

  @Override
  public void onAuthenticationFailed(AuthenticationException loginDetails) {
    // 当登录失败后，要做的业务逻辑在这里
  }

}
