package com.biz.crm.ems.admin.web.notifier;

import com.biz.crm.mdm.business.customer.user.sdk.service.CustomerUserVoService;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelaRoleVo;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import com.bizunited.nebula.security.sdk.event.AuthenticationUserEventListener;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 获取当前登陆者所具备的角色（roleCode）
 * @author pengxi
 * @date  2021/12/07
 */
@Slf4j
@Component("AuthenticationUserEventListenerImpl")
public class AuthenticationUserEventListenerImpl implements AuthenticationUserEventListener {

  @Autowired
  private CustomerUserVoService customerUserVoService;

  @Override
  public Set<String> onRequestRoleCodes(String tenantCode, String account) {
    if (StringUtils.isBlank(tenantCode) || StringUtils.isBlank(account)) {
      return Sets.newHashSet();
    }

    CustomerUserVo customerUserVo = this.customerUserVoService.findByUserName(account);
    if (customerUserVo == null) {
      return Sets.newHashSet();
    }
    //角色
    List<CustomerUserRelaRoleVo> roleInfoList = customerUserVo.getRoleInfoList();
    if(CollectionUtils.isEmpty(roleInfoList)) {
      return Sets.newHashSet();
    }

    Set<String> roleCodes = roleInfoList.stream().map(CustomerUserRelaRoleVo::getRoleCode).collect(Collectors.toSet());
    log.info("AuthenticationUserEventListenerImpl获取当前登陆者所具备的角色:{}", roleCodes);
    return roleCodes;
  }
}

