package com.biz.crm.ems.admin.web.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.ems.admin.web.dto.ResetPasswordDto;
import com.biz.crm.ems.admin.web.service.ResetPasswordService;
import com.biz.crm.mdm.business.customer.user.sdk.constant.CustomerUserConstant;
import com.biz.crm.mdm.business.customer.user.sdk.dto.CustomerUserResetPasswordDto;
import com.biz.crm.mdm.business.customer.user.sdk.service.CustomerUserVoService;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import com.bizunited.nebula.common.util.Aes128Utils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

import java.nio.charset.StandardCharsets;
import java.util.Collections;

/**
 * 重置密码服务实现
 *
 * @author pengxi
 */
@Slf4j
@Service
public class ResetPasswordServiceImpl implements ResetPasswordService {

  @Autowired
  private LoginUserService loginUserService;

  @Autowired
  private CustomerUserVoService customerUserVoService;

  @Override
  public void updatePasswordInLoginStatus(ResetPasswordDto resetPasswordDto) {
    LoginUserDetailsForEMS loginDetails = this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
    Validate.notNull(loginDetails, "请您先登录！");
    Validate.notBlank(resetPasswordDto.getOriginalPassword(), "原密码不能为空！");
    Validate.notBlank(resetPasswordDto.getNewPassword(), "新密码不能为空！");
    Validate.notBlank(resetPasswordDto.getConfirmPassword(), "确认密码不能为空！");
    Validate.isTrue(resetPasswordDto.getNewPassword().equals(resetPasswordDto.getConfirmPassword()), "新密码与确认密码不一致，请重新输入！");
    CustomerUserVo customerUserVo = this.customerUserVoService.findByUserName(loginDetails.getAccount());
    Validate.notNull(customerUserVo, "登录账号找不到或已删除！");

    // 检查原密码是否输入正确
    String oldPassword = Aes128Utils.decrypt(
            resetPasswordDto.getOriginalPassword(),
            CustomerUserConstant.ENCRYPT_KEY,
            Aes128Utils.EncodeType.CBC,
            Aes128Utils.Padding.PKCS_7_PADDING);
    String originalPassword = DigestUtils.md5DigestAsHex(oldPassword.getBytes(StandardCharsets.UTF_8));
    Validate.isTrue(originalPassword.equals(customerUserVo.getUserPassword()), "原密码不正确！");

    // 修改新密码
    CustomerUserResetPasswordDto customerUserResetPasswordDto = new CustomerUserResetPasswordDto();
    customerUserResetPasswordDto.setPassword(resetPasswordDto.getNewPassword());
    customerUserResetPasswordDto.setIds(Collections.singletonList(customerUserVo.getId()));
    this.customerUserVoService.updatePasswordByIds(customerUserResetPasswordDto);
  }
}